#ifndef __DM_AUTO_DISCOVERY_H__
#define __DM_AUTO_DISCOVERY_H__

////////////////////////////////////////////////////////////////////////////////

// The following structures are packed because they are going out on ethernet,
// so the receiver of the packet needs to know exactly where things are

#define MAX_DEVICE_NAME_LENGTH          0x80

#include "dm_begin_packed.h"

typedef struct
{
    CIP_HEADER_INFO Header;
    UINT16          Flags;
    UINT16          CIP_ID;
    char            HostName[MAX_DNS_NAME_LENGTH];
} CIP_AUTODISCOVERY_QUERY_MSG;

typedef struct
{
    CIP_HEADER_INFO Header;
    UINT16          Flags;
    UINT16          CIP_ID;
    char            LocalHostName[MAX_DNS_NAME_LENGTH];
    char            FirmwareName[MAX_DEVICE_NAME_LENGTH];
} CIP_AUTODISCOVERY_RESPONSE_MSG;

typedef struct
{
    CIP_HEADER_INFO Header;
    char            HostName[MAX_DNS_NAME_LENGTH];
} CIP_HOSTNAME_QUERY_MSG;

typedef struct
{
    CIP_HEADER_INFO Header;
    UINT32          IP_Address;
    char            HostName[MAX_DNS_NAME_LENGTH];
} CIP_HOSTNAME_RESPONSE_MSG;

typedef struct
{
    CIP_HEADER_INFO Header;
    char            HostName[MAX_DNS_NAME_LENGTH];
} CIP_HOSTNAME_SET_MSG;

typedef struct
{
    CIP_HEADER_INFO Header;
} CIP_HOSTNAME_ACK_MSG;

#include "dm_end_packed.h"

extern void (*g_pFuncUpdateDownstreamIpt)(void);

#ifdef __cplusplus
extern "C" {
#endif

////////////////////////////////////////////////////////////////////////////////

extern INT32 AutodiscoveryReceive(void * pPkt, UINT32 packet_length, UINT32 srcIpAddr);
extern INT32 AutodiscoverySend(void * ResponsePtr, UINT32 packet_length, UINT32 destIpAddr);
extern void AutodiscoveryLED(unsigned char val);
extern BOOL AutodiscoveryIsBlinking(void);
extern void AutodiscoverySetupButtonPressed(void);
INT32 AutodiscoveryGetHostByName(char * HostName, UINT32 * pIpAddr);
extern BOOL AutodiscoveryIsEnabled(void);
extern void AutodiscoverySetEnabled(BOOL set);
void AutodiscoveryRespondToNoIpTableQuery(BOOL set);
extern void AutodiscoveryClearCache(void);
extern void AutodiscoveryIPAddressChange(UINT32 inst);
extern void AutodiscoveryEthernetLinkUp(UINT32 inst);
extern void AutodiscoveryEthernetLinkDown(UINT32 inst);
extern void AutodiscoveryHostnameChange(void);
extern void AutodiscoveryCIPReady(void);
extern void AutodiscoverySave(BOOL on);
extern void AutodiscoveryPrintHostsTable(void);
extern void AutodiscoveryGetFirmwareName(char * p, UINT32 maxBytes);
extern INT32 AutodiscoveryWaitForHostnameResp(UINT32 msec);
extern void AutodiscoveryHostnameRespEvent(void);
extern void AutodiscoverySetDebugLevel(UINT32 level);
extern UINT32 AutodiscoveryGetDebugLevel(void);
extern INT32 AutodiscoveryInit(void);

// MNT - 9/4/2008 - The following function is a callback to be implemented by all
// devices who use autodiscovery
extern void AutoDiscoverySetDeviceBlink(BOOL on);
INT32 AutodiscoveryCmd(UINT32 ignore, char *cmd);

extern INT32 OSGetHostByName(char * p, UINT32 * pIpAddr);

////////////////////////////////////////////////////////////////////////////////
#ifdef __cplusplus
}
#endif

#endif

